/*jslint continue: true, plusplus: true, regexp: true, vars: true*/
/*global jQuery, alert, console, navigator*/

var baseObj = (function () {
	"use strict";
	/* var, methods */
	var init,
		checkUA,
		checkDisplay,
		uaDevice,
		uaBrouser,
		pixelRatio,
		setForm;
		// manageTopSlide;

	checkUA = function () {
		var userAgent = navigator.userAgent.toLowerCase();
		var appVersion = navigator.appVersion.toLowerCase();
		// デバイス判定
		if (userAgent.indexOf('iphone') > 0 || userAgent.indexOf('ipad') > 0 || userAgent.indexOf('ipod') > 0 || userAgent.indexOf('android') > 0) {
			uaDevice = 'device-mobile';
			
			if (userAgent.indexOf('android') > 0) {
				jQuery("body").addClass("forandroid");
			}
		}
		// ブラウザ判定
		if (userAgent.indexOf('opera') !== -1) {
			uaBrouser = 'opera';
		} else if (userAgent.indexOf("msie") !== -1) {
			if (appVersion.indexOf("msie 6.") !== -1) {
				uaBrouser = 'ie6';
			} else if (appVersion.indexOf("msie 7.") !== -1) {
				uaBrouser = 'ie7';
			} else if (appVersion.indexOf("msie 8.") !== -1) {
				uaBrouser = 'ie8';
			} else if (appVersion.indexOf("msie 9.") !== -1) {
				uaBrouser = 'ie9';
			} else {
				uaBrouser = 'ie';
			}
		} else if (userAgent.indexOf('trident') !== -1) {
			uaBrouser = 'ie11';
		} else if (userAgent.indexOf('chrome') !== -1) {
			uaBrouser = 'chrome';
		} else if (userAgent.indexOf('safari') !== -1) {
			uaBrouser = 'safari';
		} else if (userAgent.indexOf('firefox') !== -1) {
			uaBrouser = 'firefox';
		} else {
			uaBrouser = false;
		}
	};

	// retinaかどうかをチェック
	checkDisplay = function () {
		pixelRatio = window.devicePixelRatio;
	};
	
	setForm = function () {
		if (!jQuery("body").hasClass("page_entry_form")) {
			return false;
		}
		
		var formWrapPage = jQuery("#js-formWrapPage"),
			eventType = (uaDevice === 'device-mobile') ? 'touchend' : 'click';
		
		setTimeout(function () {
			jQuery(".formbg3").addClass("active");
			if (uaBrouser == 'ie9') {
				jQuery(".formbg3").animate({
					width: "400%",
					marginLeft: "-200%",
					marginBottom: "-200%"
				}, 2500);
			}
			setTimeout(function () {
				if (uaBrouser == 'ie9') {
					formWrapPage.animate({
						top: 0,
						opacity: 1
					}, 1000);
				} else {
					formWrapPage.addClass("active");
				}
			}, 1800);
		}, 500);
		
	};
	
	init = function () {
		checkUA();
		checkDisplay();
		setForm();
	};

	return {
		init: init
	};

}());

baseObj.init();