//カンマ変換
var commaConversion = function(val, comma, period) {
	var str = isFinite(val) ? String(val) : val ;
	comma = comma || ',';		//commaが「,」でなければcommaを返す（||演算子）。
	period = period || '.';		//periodが「,」でなければperiodを返す（||演算子）。

	//カンマ削除
	str = str.replace(/,/g, "");

	//小数点で分ける
	var split = str.split(period);
	var numeric = split[0];
	var decimal = split.length > 1 ? period + split[1] : '';	//少数点以下の値を抽出。

	//カンマ追加
	while(numeric != (numeric = numeric.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
	str = numeric + decimal

	return str;
};

//入力チェック
//１文字目が「-」、「0-9」
//２文字目以降は「0-9」、「,」
//上記の内容合わない文字が出てきたらそれ以降は削除
var inputCheck = function(val) {
	var str = isFinite(val) ? String(val) : val ;	//String変換
	var p = /^(\-?\d+)([0-9\,]*)/g;					//桁数区切り（正規表現）
	//var p = /^(\d+)([0-9\,]*)/g;					//桁数区切り（正規表現）※マイナス無
	var p2 = /^(\.){1}([0-9])+/;					//小数点以降数値（正規表現）
	//var p3 = /^(\-0|0)/;							//0始まりチェック（正規表現）
	//var p4 = /^(\-0|0){1}([\.]){1}/;				//0始まりチェック（正規表現）
	//var p5 = /([^0-9])/;							//0始まりチェック（正規表現）
	
	//0始まりチェック
	/*
	if(p3.test(str)){
		//小数点以外なら
		var zero_result = p4.exec(str);
		if(zero_result != null){
			if(RegExp.leftContext!=""){
				return "";
			} else {
				//小数点以降の文字が無い場合
				if(RegExp.rightContext==""){
					return "";
				}
				//小数点以降数値以外の文字がある場合
				if(p5.test(RegExp.rightContext)){
					return "";
				}
			}
		} else {
			if(str == "-0"){
				return "";
			}
		}
	}
	*/
	
	var result = p.exec(str);
	if(result != null){
		if(RegExp.leftContext!=""){
			str = "";
		} else {
			str = result[0];

			//少数点以降数値なら
			result = p2.exec(RegExp.rightContext);
			if(result != null){
				if(RegExp.leftContext!=""){
					//何もしない
				} else {
					str += result[0];
				}
			} else {
				//何もしない
			}
		}
	} else {
		str = "";
	}

	return str;
}

$(function(){
	//フォーカスインイベント
	$(".thousand_separator").on("focus",function(e){
		if($(this).val() != ""){
			var val = String($(this).val()).replace(/,/g, "");
			$(this).val(val);
			
			//キャレット 末尾を移動
			e.preventDefault();
			var elem = e.target;
			elem.setSelectionRange(val.length, val.length);
		}
	});
	//フォーカスアウトイベント
	$(".thousand_separator").on("blur",function(){
		if($(this).val() != ""){
			var val = inputCheck($(this).val());	//入力チェック
			$(this).next("#answer2").val(val).change();
			//カンマ変換
			if(val != ""){
				val = commaConversion(val);
			}
			$(this).val(val);
		} else {
			$(this).next("#answer2").val(val).change();
		}
	});
	//Enterキーイベント
	$(".thousand_separator").keypress(function(event){
		if(event.which === 13){
			$(this).blur();
		}
	});
	//フォーカスインイベント
	$(".thousand_separator2").on("focus",function(e){
		if($(this).val() != ""){
			var val = String($(this).val()).replace(/,/g, "");
			$(this).val(val);
			
			//キャレット 末尾を移動
			e.preventDefault();
			var elem = e.target;
			elem.setSelectionRange(val.length, val.length);
		}
	});
	//フォーカスアウトイベント
	$(".thousand_separator2").on("blur",function(){
		if($(this).val() != ""){
			var val = inputCheck($(this).val());	//入力チェック
			$(this).next("#answer3").val(val).change();
			//カンマ変換
			if(val != ""){
				val = commaConversion(val);
			}
			$(this).val(val);
		} else {
			$(this).next("#answer3").val(val).change();
		}
	});
	//Enterキーイベント
	$(".thousand_separator2").keypress(function(event){
		if(event.which === 13){
			$(this).blur();
		}
	});
	//フォーカスインイベント
	$(".thousand_separator3").on("focus",function(e){
		if($(this).val() != ""){
			var val = String($(this).val()).replace(/,/g, "");
			$(this).val(val);
			
			//キャレット 末尾を移動
			e.preventDefault();
			var elem = e.target;
			elem.setSelectionRange(val.length, val.length);
		}
	});
	//フォーカスアウトイベント
	$(".thousand_separator3").on("blur",function(){
		if($(this).val() != ""){
			var val = inputCheck($(this).val());	//入力チェック
			$(this).next("#answer4").val(val).change();
			//カンマ変換
			if(val != ""){
				val = commaConversion(val);
			}
			$(this).val(val);
		} else {
			$(this).next("#answer4").val(val).change();
		}
	});
	//Enterキーイベント
	$(".thousand_separator3").keypress(function(event){
		if(event.which === 13){
			$(this).blur();
		}
	});});